;This program is used in the ARRL's Big Project Fox Hunter Controller Project. 
;The program is intended to control a fox hunt transmitter in accordance with
;published fox hunt rules as closely as possible.  There are 5 transmitters in a typical
;fox hunt, MOE through MO5.  Each fox transmitter takes its turn during a 5 minute
;period to transmit a carrier for one minute.  During the one minute of transmission time,
;the fox transmits the appropriate callsign in Morse code, at approximately 12 WPM.  Toward
;the end of the one minute transmission period, the amateur radio callsign of the control
;operator is transmitted to satisfy the FCC ID requirement.  At the end of the one minute
;transmission period, the fox turns off the carrier signal and awaits 4 minutes to beging
;transmission of the next one minute period.  The program is set up to monitor the frequency
;during reception period for the start DTMF tones from the base station radio for control of
;all foxes.  DTMF 1 sycronizes all 5 foxes to begin the event.  DTMF 0 turns all foxes to 
;stand-by.  The DTMF 0 cmmand needs to be sent twice because during the event, one of the foxes
;will be transmitting, therefore the control operator must wait for the last fox to return to 
;receive mode and then resend the DTMF 0 command.  Also the commands must be transmitted from
;a radio with sufficient signal strength to overcome all other fox transmissions on the frequency.
;Program written by
;Mark Spencer, WA8SME, Project Coordinator.  Phone 860-594-0396 or e-mail
;mspencer@arrl.org.


	list      p=12F675       ; list directive to define processor
	#include <p12f675.inc>    ; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define	clk		0x02					;GPIO pin 2 as clock
#define	MOSI	0x00					;GPIO pin 0 as data
#define	CS		0x01					;GPIO pin 1 as chip select
#define	tone		0x04			;GPIO pin 4 is audio tone output pin
#define	ptt			0X05			;GPIO pin 5 is ptt control pin
#define	time_tweek	.118			;constant to tweek minute timer
	
;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	test_byte		;used has workspace for pin change interrupt
	minute_up		;used in minute segment routines
	transmit_on		;used as transmit on flag
	count_down		;used to track minute segment (1 through 5)
	message_counter	;used in message loops
	half_dit		;used in tmr0 dit time element
	end_dit			;used to signal end of dit time element
	tempa			;delay counter
	count			;delay counter
	tmr1_count		;used in tmr1 timer
	bit_counter
	temp
	endc

;******************************************************************************
;Macros change values here for fox number, fox callsign and your callsign
;******************************************************************************
;#define fox_number	.1		;change this value for the fox

set_message_counter	macro
	movlw	.10			;.10 message count for moe, .9 for moi, mos and moh, .8 mo5
	movwf	message_counter
	endm
	
mo			macro
	call	m
	call	o
	call	e				;change to e, i, s, h, or five as appropriate
	call	word_space
	call	word_space
	call	word_space
	call	word_space
	call	word_space
	endm

callsign	macro
	call	a				
	call	g				;be for "b"
	call	seven			;spell out numbers
	call	j
;	call	
;	call	
	call	word_space
	call	ar
	endm

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	bcf		INTCON,GIE	;disable global interups

;	btfsc	INTCON,GPIF	;check if interrupt came from port change, skip if no
;	goto	port_change_interrupt

	btfsc	PIR1,TMR1IF	;check if interrupt came from tmr1, skip if no
	call	tmr1_interrupt

	btfsc	INTCON,T0IF	;check if interrupt came from tmr0, skip if no
	call	tmr0_interrupt


	bsf		INTCON,GIE	;enable global interupts	
	return				; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
;	movlw	0x38
	call    0x3FF      ; retrieve factory calibration value
						; comment instruction if using simulator, ICD2, or ICE2000
	
	BANKSEL	Bank1		; BANK1
	movwf   OSCCAL      ; update register with factory cal value 
	clrf	TRISIO
;	movlw	D0_1Tris	; set direction pin 0 as output, all other input
;	movwf	TRISIO		; 
	clrf	ANSEL		; configure A/D I/O as digital	
;	bsf		WPU,DTMF_0	;enable weak pull up on pin 0
;	bsf		WPU,DTMF_1	;enable weak pull up on pin 1
;	bsf		WPU,DTMF_2	;enable weak pull up on pin 2
						;no weak pull up on pin 3 so one is hard wired
;	bcf		OPTION_REG,7;enable weak pull ups
;tmr0 timer set up
	bcf		OPTION_REG,5;set up tmr0 to internal clock
	bcf		OPTION_REG,4;low-to-high trasistion
	bcf		OPTION_REG,3;prescaler assgined to tmr0
	bsf		OPTION_REG,2;prescaler rate set to 1:256
	bsf		OPTION_REG,1;
	bsf		OPTION_REG,0;
;tmr1 timer set up
	bsf		PIE1,TMR1IE	;enable timr1 interupt
;	bsf		IOC,DTMF_0	;enable interrupt on change pin 0
;	bsf		IOC,DTMF_1	;enable interrupt on change pin 1
;	bsf		IOC,DTMF_2	;enable interrupt on change pin 2
;	bsf		IOC,DTMF_3	;enable interrupt on change pin 3
	BANKSEL	Bank0		; change back to PORT memory bank
	movlw	0x007		; disconnect comparitor
	movwf	CMCON		;
;	movfw	GPIO		;read GPIO to clear mismatch condition
;	bcf		INTCON,GPIF	;clear port change interuupt flag
	bsf		T1CON,T1CKPS1; prescaler to 1:8
	bsf		T1CON,T1CKPS0;
	bcf		T1CON,TMR1CS;internal clock
	bcf		T1CON,TMR1GE;tmr1 allowed to be turned on
;	bsf		INTCON,GPIE	;enable port change interrupt
	bsf		INTCON,PEIE	;enable peripheral interrupts (for tmr1)
	bsf		INTCON,GIE	;enable global interrupts
	bcf		GPIO,tone	; tone bit 4 clear as starting state
	bcf		GPIO,ptt	; ptt bit 5 clear as starting state
	clrf	end_dit		;clear flag
	clrf	half_dit	;clear flag
	clrf	transmit_on	;transmit on flag
	bsf		GPIO,CS		;high is un slect
	bcf		GPIO, MOSI	;start with data line low
	bcf		GPIO, clk	;start with clock line low
	bsf		GPIO, ptt	;start with PTT line high (off)
;	call	delay5ms

;******************************************************************************
;Main 
;******************************************************************************

main							;loop waiting for turn on command	
;	goto 	main

	call	wait300ms
	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms

;call	start_bit
;movlw	.1
;call 	send_byte
;call	start_bit
;movlw	.1
;call	send_byte
;call	start_bit
;movlw	.144
;call	send_byte
	bcf		GPIO, CS		;select TX
	movlw	"D"
	call	send_byte

;146520 = 08 bb b7 c0 in hex
	movlw	"1"

	call	send_byte
	movlw	"4"

	call	send_byte
	movlw	"6"

	call	send_byte
	movlw	"5"

	call	send_byte
	movlw	"5"
	call	send_byte
	movlw	"0"

	call	send_byte
	movlw	"0"
	call	send_byte
	movlw	"0"
	call	send_byte
	movlw	"0"
	call	send_byte
;

	bsf		GPIO, CS


;
;	call	stop_bit
;loopback
;	bcf		GPIO, ptt			;TX on
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	bsf		GPIO, ptt			;tx off
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	call	wait300ms
;	goto	loopback

turned_on

	bsf		transmit_on,0		;set transmit on flag
	movlw	time_tweek			;adjust this value to tweek the 1 minute timer
	movwf	tmr1_count
	clrf	minute_up			;clear minute_up flag
	bsf		T1CON,TMR1ON		;turn on tmr1

minute1

	call	transmit
;	btfss	minute_up,0			;check if minute_up flag is set, skip if set
;	goto	minute1				;keep looping until minute is up
;	bcf		minute_up,0			;clear minute_up flag for next minute
;	movlw	time_tweek
;	movwf	tmr1_count			;reset timer counter
	
minute2

;	call	transmit
	btfss	minute_up,0			;check if minute_up flag is set, skip if set
	goto	minute2				;keep looping until minute is up
	bcf		minute_up,0			;clear minute_up flag for next minute
	movlw	time_tweek
	movwf	tmr1_count			;reset timer counter

minute3
	
;	call	transmit
	btfss	minute_up,0			;check if minute_up flag is set, skip if set
	goto	minute3				;keep looping until minute is up
	bcf		minute_up,0			;clear minute_up flag for next minute
	movlw	time_tweek
	movwf	tmr1_count			;reset timer counter


minute4
	
;	call	transmit
	btfss	minute_up,0			;check if minute_up flag is set, skip if set
	goto	minute4				;keep looping until minute is up
	bcf		minute_up,0			;clear minute_up flag for next minute
	movlw	time_tweek
	movwf	tmr1_count			;reset timer counter

minute5

;	call	transmit
	btfss	minute_up,0			;check if minute_up flag is set, skip if set
	goto	minute5				;keep looping until minute is up
	bcf		minute_up,0			;clear minute_up flag for next minute
	movlw	time_tweek
	movwf	tmr1_count			;reset timer counter

	goto	minute1

;******************************************************************************
;Subroutines & Functions
;******************************************************************************
send_byte
	movwf	temp
	movlw	.8
	movwf	bit_counter
send_byte_loop
	bsf		GPIO,MOSI			;assume high bit
	rlf		temp,f				;send msb first
	btfss	STATUS,C			;skip if carry bit is set
	bcf		GPIO,MOSI			;clear bit
	call	delay1ms
	bsf		GPIO, clk			;clock high
	call	delay1ms
	bcf		GPIO, clk			;clock low
	call	delay1ms
	decfsz	bit_counter,f		;check if last bit
	goto	send_byte_loop
;BANKSEL	Bank1
;bsf		TRISIO,1			;set at input
;	bsf		GPIO,clk
;BANKSEL	Bank0
;	call	delay1ms
;	bcf		GPIO, clk
;	call	delay1ms
;bcf		GPIO, scl			;clock in 9th bit
;BANKSEL Bank1
;bcf		TRISIO,1
;BANKSEL	Bank0
;	call	delay1ms
;	bsf		GPIO,sda
;	call	delay1ms
	return

start_bit
;	bsf		GPIO, sda			;ensure data high
;	call	delay1ms
;	bsf		GPIO, scl			;set clock high
;	call	delay1ms
;	bcf		GPIO, sda			;set data low for start
;	call	delay1ms
;	bcf		GPIO, scl			;set clock low
;	call	delay1ms
	return

stop_bit
;	bcf		GPIO, sda			;set data low
;	bsf		GPIO, scl			;set clock high
;	call	delay1ms
;	bsf		GPIO, sda			;set data high for stop
;	call	delay1ms
;	bcf		GPIO, scl
	return


transmit
	bcf		GPIO,ptt			;turn on ptt
send_message
	set_message_counter			;sets counter for the appropriate fox ID length
hold
	decfsz	message_counter,F	;count down to zero then skip next
	goto	send_mo
	callsign					;send callsign when counter time is up
	goto	next_minute			;continue with next minute
send_mo
	mo
	goto	hold				;continue to send mo until count is zero
next_minute
	btfss	minute_up,0			;if minute_up flag set, then go to next minute
	goto	next_minute			;continue with current minute until tmr1 interrup
	clrf	minute_up			;clear minute_up flag
	movlw	time_tweek			;reset minute tweeking values for next minute
	movwf	tmr1_count
	bsf		GPIO,ptt			;turn off ptt
	return

turn_on_fox
	call	wait300ms			;delay for control tx unkey
	call	wait300ms
	call	wait300ms
	call	wait300ms
	bsf		INTCON,GPIE			;enable port change interrupt all interrupts
	bsf		INTCON,GIE			;enable global interupts
	goto	turned_on

;turn_off_fox
;	bsf		INTCON,GPIE			;enable port change interrupt all interrupts
;	bsf		INTCON,GIE			;enable global interupts
;	bcf		GPIO,ptt			;force ptt off
;	bcf		GPIO,tone			;low on tone	
;	bcf		transmit_on,0		;clear transmit on flag
;	bcf		INTCON,T0IF			;clear tmr0 interupt flag
;	bcf		INTCON,T0IE			;enable tmr0 interupt
;	bcf		T1CON,TMR1ON		;turn off tmr1
;	goto	main

;toggle_fox
;	bsf		INTCON,GIE	;enable global interrupts
;	btfss	transmit_on,0		;check if transmit flag set, then go to turn off	
;	goto	turn_on_fox			;if transmit flag clear, go to then turn on
;	goto	turn_off_fox
;	goto	main				;just a safety line, not really needed


;******************************************************************************
;interupt handling routines
;******************************************************************************

;port_change_interrupt
;	movfw	GPIO				;read to clear mismatch condition
;	andlw	b'00001111'			;mask upper nibble
;	movwf	test_byte			;put result in working space
;	bcf		INTCON,GPIF			;clear port change interupt flag
;	bcf		INTCON,GPIE			;disable port change interrupt all interrupts
;
;	movlw	.13					;for "A" key
;	xorwf	test_byte,w		
;	btfsc	STATUS,Z			;skip next if not "A"
;	goto	turn_on_fox
;	movlw	.10					;for zero key
;	xorwf	test_byte,w
;	btfsc	STATUS,Z			;skip next if not zero
;	goto	turn_off_fox
;	movlw	fox_number
;	xorwf	test_byte,w
;	btfsc	STATUS,Z			;skip next if not fox_number
;	goto	toggle_fox	
;	bsf		INTCON,GPIE			;enable port change interrupt all interrupts
;	bsf		INTCON,GIE			;enable global interupts
;	retfie


tmr1_interrupt
	
	bcf		PIR1,TMR1IF			;clear interrupt flag
	decfsz	tmr1_count,F		;decrement and check if done, skip to next if done
	retfie
	bsf		minute_up,0			;set minute_up flag when minute is complete
	retfie

tmr0_interrupt
	bcf		INTCON,T0IE			;disable tmr0 interup
	bcf		INTCON,T0IF			;clear tmr0 overflow flag
	bsf		INTCON,GIE			;enable global interrupts
	btfsc	half_dit,0			;check if first half of bit, if yes then go on
	goto	second_half
first_half
	movlw	.122				;load w with required particial countdown
	movwf	TMR0		
	bsf		half_dit,0			;set first half_dit complete flag
	bcf		end_dit,0			;incremtn end_dit complete flag
	bsf		INTCON,T0IE			;enable tmr0
	retfie						;out_of_first_half_dit_element
second_half
	bcf		half_dit,0			;clear first half_dit complete flag
	bsf		end_dit,0			;set end_dit complete flag
	bcf		GPIO,tone			;turn off tone
	bcf		INTCON,T0IE			;disable tmr0, dit time element done
	retfie						;second_half

;******************************************************************************
;character element generation routines
;******************************************************************************

dit
	call 	dit_make
	call	element_space
	return

dah
	call	dit_make
	call	dit_make
	call	dit_make
	call	element_space
	return

dit_make
	bcf		INTCON,T0IF			;clear tmr0 interupt flag
	bsf		INTCON,T0IE			;enable tmr0 interupt
	bsf		INTCON,GIE			;enable global interupts
dit_loop						;generate 1000 Hz tone
	bsf		GPIO,tone
	call	delay05ms
	bcf		GPIO,tone
	call	delay05ms
	btfss	end_dit,0			;if end of dit time element, exit tone generator
	goto 	dit_loop	
	bcf		end_dit,0
	return

element_space
	bcf		INTCON,T0IF			;clear tmr0 interupt flag
	bsf		INTCON,T0IE			;enable tmr0 interupt
	bsf		INTCON,GIE			;enable global interupts
space_loop
	btfss	end_dit,0
	goto	space_loop
	bcf		end_dit,0
	return

character_space
	call	element_space
	call	element_space
	return

word_space
	call	character_space
	call	character_space
	call	character_space
	return

;******************************************************************************
;Morse code letter and number routines
;******************************************************************************
a
	call	dit
	call	dah
	goto	end_character

be
	call	dah
	call	dit
	call	dit
	call	dit
	goto	end_character

c
	call	dah
	call	dit
	call	dah
	call	dit
	goto	end_character

d
	call	dah
	call	dit
	call	dit
	goto	end_character

e
	call	dit
	goto	end_character

f
	call	dit
	call	dit
	call	dah
	call	dit
	goto	end_character

g
	call	dah
	call	dah
	call	dit
	goto	end_character

h
	call	dit
	call	dit
	call	dit
	call	dit
	goto	end_character

i
	call	dit
	call	dit
	goto	end_character

j
	call	dit
	call	dah
	call	dah
	call	dah
	goto	end_character

k
	call	dah
	call	dit
	call	dah
	goto	end_character

l
	call	dit
	call	dah
	call	dit
	call	dit
	goto	end_character

m
	call	dah
	call	dah
	goto	end_character

n
	call	dah
	call	dit
	goto	end_character
	
o
	call	dah
	call	dah
	call	dah
	goto	end_character

p
	call	dit
	call	dah
	call	dah
	call	dit
	goto	end_character

q
	call	dah
	call	dah
	call	dit
	call	dah
	goto	end_character

r
	call	dit
	call	dah
	call	dit
	goto	end_character

s
	call	dit
	call	dit
	call	dit
	goto	end_character

t
	call	dah
	goto	end_character

u
	call	dit
	call	dit
	call	dah
	goto	end_character

v
	call	dit
	call	dit
	call	dit
	call	dah
	goto	end_character

w
	call	dit
	call	dah
	call	dah
	goto	end_character

x
	call	dah
	call	dit
	call	dit
	call	dah
	goto	end_character

y
	call 	dah
	call	dit
	call	dah
	call	dah
	goto	end_character

z
	call	dah
	call	dah
	call	dit
	call	dit
	goto	end_character

one
	call	dit
	call	dah
	call	dah
	call	dah
	call	dah
	goto	end_character

two
	call	dit
	call	dit
	call	dah
	call	dah
	call	dah
	goto	end_character

three
	call	dit
	call	dit
	call	dit
	call	dah
	call	dah
	goto	end_character

four
	call	dit
	call	dit
	call	dit
	call	dit
	call	dah
	goto	end_character

five
	call	dit
	call	dit
	call	dit
	call	dit
	call	dit
	goto	end_character

six
	call	dah
	call	dit
	call	dit
	call	dit
	call	dit
	goto	end_character

seven
	call	dah
	call	dah
	call	dit
	call	dit
	call	dit
	goto	end_character

eight
	call	dah
	call	dah
	call	dah
	call	dit
	call	dit
	goto	end_character

nine
	call	dah
	call	dah
	call	dah
	call	dah
	call	dit
	goto	end_character

zero
	call	dah
	call	dah
	call	dah
	call	dah
	call	dah
	goto	end_character

ar
	call	dit
	call	dah
	call	r
	
end_character
	call	character_space
	return

;******************************************************************************
;timing delay routines
;******************************************************************************		

wait300ms
	call	delay50ms
wait250ms
	call	delay50ms
	call	delay50ms
	call	delay50ms
	call	delay50ms
	return

delay05ms					;delay .5 ms for tone generation
	movlw	.98
	movwf	count
	nop
	goto	$+1
	;goto	$+1
dly05ms
	goto	$+1
	decfsz	count,F
	goto	dly05ms
	retlw	0

delay1ms
	movlw	.197
	movwf	count
	nop
	goto	$+1
	goto	$+1
dly1ms
	goto	$+1
	decfsz	count,F
	goto	dly1ms
	retlw	0

delay5ms
	call	delay1ms
	call	delay1ms
	call	delay1ms
	call	delay1ms
	call	delay1ms
	movlw	.4
	movwf	count
tweek5ms
	decfsz	count,F
	goto	tweek5ms
	return

delay50ms
	movlw	.50
	movwf	tempa
dly50ms
	call	delay1ms
	decfsz	tempa,F
	goto	dly50ms
	movlw	.14
	movwf	count
tweek50ms
	decfsz	count,f
	goto	tweek50ms
	retlw	0

delay200ms
	movlw	.200
	movwf	tempa
dly200ms
	call	delay1ms
	decfsz	tempa,F
	goto	dly200ms
	movlw	.64
	movwf	count
tweek200ms
	decfsz	count,F
	goto	tweek200ms
	retlw	0

program_end	
	END			; directive 'end of program'


